﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Option Explicit On

Imports System.Xml
Imports System.IO
Imports System.Collections.Generic


Public Class MainForm

    'XML 任务的集合
    Private taskList As List(Of Task)

    '使用 DOM 的窗体级变量
    Private xmlDoc As XmlDocument
    Private xmlNode As XmlNode
    Private xmlNodeList As XmlNodeList

    '位于应用程序 bin 文件夹中的 XML 源文件
    Private modifyXmlFile As String = My.Application.Info.DirectoryPath & "\..\..\new.xml"
    Private simpleXmlFile As String = My.Application.Info.DirectoryPath & "\..\..\simple.xml"
    Private badXmlFile As String = My.Application.Info.DirectoryPath & "\..\..\bad.xml"

    '用于保存操作之间的状态的临时文件
    Private tempModifyXmlFile As String = My.Application.Info.DirectoryPath & "\temp_new.xml"
    Private tempSimpleXmlFile As String = My.Application.Info.DirectoryPath & "\temp_simple.xml"

    Private Const FindNodesXPath As String = "//Item[New]"
    Private Const FindNodeXPath As String = "//Department[@Name='Fruits']"

    Private formattedNewLine As String = vbCrLf & New String("="c, 35) & vbCrLf

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load, MyBase.Load
        Dim fileNotFoundMsg As String = "The file '{0}' was not found.  Please place a copy in the same directory as the application Exe and restart the application."
        Dim filesNotFound As Boolean

        '确认是否有我们需要的 XML 基文件
        If My.Computer.FileSystem.FileExists(modifyXmlFile) = False Then
            MsgBox(String.Format(fileNotFoundMsg, modifyXmlFile), MsgBoxStyle.Critical, Me.Text)
            filesNotFound = True
        End If
        If My.Computer.FileSystem.FileExists(simpleXmlFile) = False Then
            MsgBox(String.Format(fileNotFoundMsg, simpleXmlFile), MsgBoxStyle.Critical, Me.Text)
            filesNotFound = True
        End If
        If My.Computer.FileSystem.FileExists(badXmlFile) = False Then
            MsgBox(String.Format(fileNotFoundMsg, badXmlFile), MsgBoxStyle.Critical, Me.Text)
            filesNotFound = True
        End If

        '填充私有任务集合
        taskList = New List(Of Task)
        taskList.Add(New Task(My.Resources.cmdLoadXmlFile, AddressOf loadAndDisplayXML))
        taskList.Add(New Task(My.Resources.cmdLoadXmlString, AddressOf loadXmlString))
        taskList.Add(New Task(My.Resources.cmdTestForChildNodes, AddressOf testForChildNodes))
        taskList.Add(New Task(My.Resources.cmdIterateAllNodes, AddressOf iterateAllNodes))
        taskList.Add(New Task(My.Resources.cmdDetermineNodeType, AddressOf determineNodeType))
        taskList.Add(New Task(My.Resources.cmdListAllElementNodes, AddressOf listAllElementNodes))
        taskList.Add(New Task(My.Resources.cmdListElementsByTag, AddressOf listElementsByTag))
        taskList.Add(New Task(My.Resources.cmdSelectNodes, AddressOf selectNodes))
        taskList.Add(New Task(My.Resources.cmdSelectNode, AddressOf selectSingleNode))
        taskList.Add(New Task(My.Resources.cmdNavigateRelatedNodes, AddressOf navigateRelatedNodes))
        taskList.Add(New Task(My.Resources.cmdRetrieveAttributes, AddressOf retrieveAttributes))
        taskList.Add(New Task(My.Resources.cmdCreateXML, AddressOf createXML))
        taskList.Add(New Task(My.Resources.cmdAddOrDeleteElements, AddressOf addDeleteElements))
        taskList.Add(New Task(My.Resources.cmdAddOrDeleteAttributes, AddressOf addDeleteAttributes))
        taskList.Add(New Task(My.Resources.cmdModifyElement, AddressOf modifyElement))
        taskList.Add(New Task(My.Resources.cmdModifyAttribute, AddressOf modifyAttribute))
        taskList.Add(New Task(My.Resources.cmdValidXML, AddressOf validXML))
        taskList.Add(New Task(My.Resources.cmdParseErrors, AddressOf parseErrors))

        '将任务列表加载到列表框
        xmlTasks.Items.Clear()
        For Each xmlTask As Task In taskList
            xmlTasks.Items.Add(xmlTask, False)
        Next

        '如果没有任何文件，则禁用列表框
        If filesNotFound Then
            xmlTasks.Enabled = False
        End If

        Me.StatusStrip1.Text = "Select an operation"
    End Sub

    Private Function loadXmlFile() As String
        '遵从更复杂的版本
        Me.loadXmlFile(False)
        Return ""
    End Function

    Private Function loadXmlFile(ByVal ForceReload As Boolean) As String
        '初始化 XML 文档
        '仅当 ForceReload 为 true 或
        '文档未初始化时才会重新加载。
        'OrElse 执行简化计算，
        '这和 Or 不同，后者执行两个测试，
        '即使 ForceReload 为 True 也是这样
        If ForceReload OrElse (xmlDoc Is Nothing) Then
            xmlDoc = New XmlDocument
            xmlDoc.Load(simpleXmlFile)
        End If
        Return ""
    End Function

    Private Function loadAndDisplayXML() As String
        Me.loadXmlFile()
        Return xmlDoc.OuterXml()
    End Function

    Private Function loadXmlString() As String
        '生成带有 XML 标记的任意字符串。
        '请注意，回车符供人阅读使用，
        'XML 处理器并不需要。
        '您可以调整分析器是否“考虑”
        '空格，方法是调整 XmlDocument 类的 PreserveWhitespace
        '属性，如下所示。

        '使用 StringWriter 类
        Dim writer As New StringWriter
        With writer
            .WriteLine("<xml>")
            .WriteLine("<Family>")
            .WriteLine("    <Person type='father'>Ben Smith</Person>")
            .WriteLine("    <Person type='mother'>Denise Smith</Person>")
            .WriteLine("    <Person type='child' gender='male'>Jeff Smith</Person>")
            .WriteLine("    <Person type='child' gender='female'>Samantha Smith</Person>")
            .WriteLine("</Family>")
            .WriteLine("</xml>")
        End With

        '初始化新的本地 XML 文档实例
        Dim xDoc As New XmlDocument
        '通知分析器保留文档中的 CRLF。
        xDoc.PreserveWhitespace = True
        xDoc.LoadXml(writer.ToString())
        writer.Close()

        Return xDoc.OuterXml()
    End Function

    Private Function testForChildNodes() As String
        '初始化 XML 文档
        Me.loadXmlFile()
        Dim writer As New StringWriter

        Dim tab2x As String = vbTab & vbTab

        '如果文档含有子节点，则
        '查看所有子节点。
        If xmlDoc.HasChildNodes Then
            For Each xmlNode In xmlDoc.ChildNodes
                With writer
                    .WriteLine(formattedNewLine)
                    .WriteLine("Name: {0}{1}", tab2x, xmlNode.Name)
                    .WriteLine("Type: {0}{1}", tab2x, xmlNode.NodeType)
                    .WriteLine("Type (String): {0}{1}", vbTab, xmlNode.NodeType.ToString())
                    .WriteLine("Value: {0}{1}", tab2x, xmlNode.Value)
                    .WriteLine("Outer XML: {0}{1}", vbTab, xmlNode.OuterXml)
                End With
            Next xmlNode
        End If
        Return writer.ToString
    End Function

    Private Function iterateAllNodes() As String
        '初始化 XML 文档。
        Me.loadXmlFile()
        Dim writer As New StringWriter

        '使用递归函数访问所有节点。
        TraverseTree(writer, xmlDoc, 0)

        Return writer.ToString

    End Function

    Private Function determineNodeType() As String
        Me.loadXmlFile()

        '使用递归函数访问所有节点。
        Dim writer As New StringWriter
        TraverseTreeType(writer, xmlDoc, 0)

        writer.Close()
        Return writer.ToString
    End Function

    Private Function listElementsByTag() As String
        '初始化 XML 文档。
        Me.loadXmlFile()

        Dim xElem As XmlElement
        Dim strTag As String
        Dim writer As New StringWriter

        strTag = InputBox("Enter an XPath expression to find:", "Enter Search Expression", FindNodesXPath)

        If strTag.Length > 0 Then
            '根据输入的 XPath 表达式查找一组节点。
            xmlNodeList = xmlDoc.SelectNodes(strTag)
            With writer
                .WriteLine("All text elements matching '{0}':", strTag)
                .WriteLine(formattedNewLine)

                If Not xmlNodeList Is Nothing Then
                    For Each xElem In xmlNodeList
                        .WriteLine("Name: " & xElem.Name)
                        .WriteLine("InnerText: " & xElem.InnerText)
                        .WriteLine("InnerXml: " & xElem.InnerXml)
                    Next xElem
                End If

            End With
        End If
        writer.Close()
        Return writer.ToString
    End Function

    Private Function listAllElementNodes() As String
        '初始化 XML 文档。
        Me.loadXmlFile()
        Dim writer As New StringWriter

        '按标记名搜索元素。
        '本示例采用硬编码，以查找 ALL (*) 元素
        xmlNodeList = xmlDoc.GetElementsByTagName("*")

        With writer
            .WriteLine("Elements matching '*':")
            .WriteLine(formattedNewLine)
            For Each xmlNode In xmlNodeList
                .WriteLine(xmlNode.Name)
            Next xmlNode
        End With

        writer.Close()
        Return writer.ToString
    End Function

    Private Function selectNodes() As String
        '初始化 XML 文档。
        Me.loadXmlFile()

        Dim xElem As XmlElement
        Dim xnodTemp As XmlNode

        '打印出每个新项的名称：
        xmlNodeList = xmlDoc.SelectNodes("//New")

        Dim writer As New StringWriter
        If xmlNodeList IsNot Nothing Then
            With writer
                .WriteLine("All New Items:")
                .WriteLine(formattedNewLine)
                For Each xmlNode In xmlNodeList
                    xnodTemp = xmlNode.ParentNode.SelectSingleNode("Name")
                    If xnodTemp IsNot Nothing Then
                        If TypeOf xnodTemp Is XmlElement Then
                            xElem = CType(xnodTemp, XmlElement)
                            .WriteLine(xElem.InnerText)
                        End If
                    End If
                Next xmlNode
            End With
        End If
        writer.Close()
        Return writer.ToString
    End Function

    Private Function selectSingleNode() As String
        '初始化 XML 文档。
        Me.loadXmlFile()
        Dim writer As New StringWriter

        Dim xElem As XmlElement

        Dim strTag As String

        strTag = InputBox("Enter an XPath expression to find:", "Enter Search Expression", FindNodeXPath)
        If strTag.Length > 0 Then
            With writer
                .WriteLine("All elements matching '{0}':", strTag)
                .WriteLine(formattedNewLine)

                xmlNode = xmlDoc.SelectSingleNode(strTag)
                If xmlNode IsNot Nothing Then
                    If TypeOf xmlNode Is XmlElement Then
                        xElem = CType(xmlNode, XmlElement)
                        .WriteLine(xElem.InnerText)
                    End If
                End If
            End With
        End If
        writer.Close()
        Return writer.ToString
    End Function

    Private Function navigateRelatedNodes() As String
        '初始化 XML 文档。
        Me.loadXmlFile()

        Dim xElem As XmlElement
        Dim xnodTemp As XmlNode

        '打印出每个新项的名称：
        xmlNodeList = xmlDoc.SelectNodes("//New")

        Dim writer As New StringWriter
        If xmlNodeList IsNot Nothing Then
            With writer
                .WriteLine("All New Items:")
                .WriteLine(formattedNewLine)
                For Each xmlNode In xmlNodeList
                    xnodTemp = xmlNode.ParentNode.SelectSingleNode("Name")
                    If xnodTemp IsNot Nothing Then
                        If TypeOf xnodTemp Is XmlElement Then
                            xElem = CType(xnodTemp, XmlElement)
                            .WriteLine(xElem.InnerText)
                        End If
                    End If
                Next xmlNode
            End With
        End If
        writer.Close()
        Return writer.ToString
    End Function

    Private Function retrieveAttributes() As String
        '初始化 XML 文档
        Me.loadXmlFile()
        Dim writer As New StringWriter

        Dim xAttr As XmlAttribute
        Dim xTmpNode As XmlNode

        With writer
            xmlNodeList = xmlDoc.SelectNodes("//Item")

            If xmlNodeList IsNot Nothing Then
                .WriteLine("All Item Attributes:")
                .WriteLine(formattedNewLine)

                For Each xmlNode In xmlNodeList
                    .WriteLine("{0} ({1})", xmlNode.Name, xmlNode.InnerText)
                    For Each xAttr In xmlNode.Attributes
                        .WriteLine("   {0}: {1}", xAttr.Name, xAttr.Value)
                    Next
                Next
            End If

            .WriteLine()
            .WriteLine()

            xmlNodeList = xmlDoc.SelectNodes("//Department")

            If xmlNodeList IsNot Nothing Then
                .WriteLine("Departments:")
                .WriteLine(formattedNewLine)

                For Each xmlNode In xmlNodeList
                    xTmpNode = xmlNode.Attributes.GetNamedItem("Name")
                    If xTmpNode IsNot Nothing Then
                        xAttr = CType(xTmpNode, XmlAttribute)
                        .WriteLine(xAttr.Value)
                    End If
                Next
            End If
        End With
        writer.Close()
        Return writer.ToString
    End Function

    Private Function createXML() As String
        '此方法显示如何完全由代码生成 XML 文件。
        Dim xDoc As New XmlDocument

        Dim xPI As XmlProcessingInstruction
        Dim xComment As XmlComment
        Dim xElmntRoot As XmlElement
        Dim xElmntFamily As XmlElement

        xPI = xDoc.CreateProcessingInstruction("xml", "version='1.0'")
        xDoc.AppendChild(xPI)

        xComment = xDoc.CreateComment("Family Information")
        xDoc.AppendChild(xComment)

        xElmntRoot = xDoc.CreateElement("xml")
        xDoc.AppendChild(xElmntRoot)

        '不是逐个新建节点，
        '而是依靠以下事实：AppendChild 返回
        '对新添加节点的引用。
        xElmntFamily = CType(xElmntRoot.AppendChild(xDoc.CreateElement("Family")), XmlElement)
        Call xElmntFamily.AppendChild(xDoc.CreateElement("Father"))

        '显然，如果我们没有权限，此操作将失败。
        '请注意，如果文件存在，则保存操作会覆盖该文件。
        '您可能希望通过类似以下的方式检查该文件是否存在：

        If My.Computer.FileSystem.FileExists(modifyXmlFile) Then
            If MsgBox(String.Format("Do you want to overwrite the file {0}?", modifyXmlFile), MsgBoxStyle.YesNo, Me.Text) = MsgBoxResult.Yes Then
                xDoc.Save(modifyXmlFile)
            End If
        End If

        xDoc.Save(tempModifyXmlFile)

        '请注意，作为输出的 XML 不“美观”。
        '分析器不引入类似
        '回车符等空白。
        Return xDoc.OuterXml
    End Function

    ''' <summary>
    '''此方法将移除一个节点，然后添加四个新节点。
    ''' </summary>
    ''' <returns>修改后的 XML</returns>
    Private Function addDeleteElements() As String
        Dim xDoc As New XmlDocument

        xDoc.Load(tempModifyXmlFile)

        Dim startXML As String = "Original XML:" & formattedNewLine & xDoc.OuterXml

        Dim xNode As XmlNode
        Dim xElmntFamily As XmlElement = Nothing
        '搜索特定节点
        xNode = xDoc.SelectSingleNode("//Family")

        If xNode IsNot Nothing Then
            If TypeOf xNode Is XmlElement Then
                xElmntFamily = CType(xNode, XmlElement)
            End If

            xElmntFamily.RemoveChild(xElmntFamily.SelectSingleNode("Father"))

            '为每个家庭成员插入节点：
            InsertTextNode(xDoc, xElmntFamily, "Person", "Ben Smith")
            '下面是 InsertTextNode 的工作内容：
            'Set xNode = xDoc.createElement("father")
            'xNode.appendChild xDoc.createTextNode("Ben Smith")
            'xElmntFamily.appendChild xNode
            InsertTextNode(xDoc, xElmntFamily, "Person", "Denise Smith")
            InsertTextNode(xDoc, xElmntFamily, "Person", "Jeff Smith")
            InsertTextNode(xDoc, xElmntFamily, "Person", "Samantha Smith")

            xDoc.Save(tempModifyXmlFile)

            '显示修改后的 XML
            Me.xmlEdit.Text = "Modified XML:" & formattedNewLine & xDoc.OuterXml
            Return startXML
        Else
            Return String.Format("Family Node was not found. Please try the '{0}' option first.", My.Resources.cmdCreateXML)
        End If

    End Function

    ''' <summary>
    '''此方法将移除 Family 节点的
    '''所有子节点，然后使用某些属性重新添加这些节点。
    '''此外，还将显示如何操作现有属性。
    ''' </summary>
    ''' <returns>修改后的 XML 字符串</returns>
    Private Function addDeleteAttributes() As String
        '此方法将移除 Family 节点的
        '所有子节点，然后使用某些属性重新添加这些节点。
        '此外，还将显示如何操作现有属性。
        Dim xDoc As New XmlDocument

        xDoc.Load(tempModifyXmlFile)

        Dim startXml As String = "Original XML:" & formattedNewLine & xDoc.OuterXml

        Dim xNode As XmlNode
        Dim xElem As XmlElement

        Dim xElmntFamily As XmlElement = Nothing

        '搜索特定节点。
        xNode = xDoc.SelectSingleNode("//Family")

        If xNode IsNot Nothing Then
            If TypeOf xNode Is XmlElement Then
                xElmntFamily = CType(xNode, XmlElement)
            End If

            '删除在以前的回答中创建的所有节点。
            For Each xNode In xElmntFamily
                xElmntFamily.RemoveChild(xNode)
            Next

            '针对每个家庭成员插入节点：
            xElem = InsertTextNode(xDoc, xElmntFamily, "Person", "Ben Smith")
            xElem.SetAttribute("type", "parent")
            xElem.SetAttribute("age", "70")

            xElem = InsertTextNode(xDoc, xElmntFamily, "Person", "Denise Smith")
            xElem.SetAttribute("type", "mother")

            xElem = InsertTextNode(xDoc, xElmntFamily, "Person", "Jeff Smith")
            xElem.SetAttribute("type", "son")

            xElem = InsertTextNode(xDoc, xElmntFamily, "Person", "Samantha Smith")
            xElem.SetAttribute("type", "daughter")

            '属性不十分正确。请修正父亲的属性。
            xNode = xDoc.SelectSingleNode("//Person[@type='parent']")
            If xNode IsNot Nothing Then
                '移除“age”属性，将“type”属性
                '更改为“father”。
                xElem = CType(xNode, XmlElement)
                xElem.Attributes.RemoveNamedItem("age")
                xElem.SetAttribute("type", "father")
            End If

            xDoc.Save(tempModifyXmlFile)
            Me.xmlEdit.Text = "Modified XML: " & formattedNewLine & xDoc.OuterXml

            Return startXml
        Else
            Return String.Format("Family Node was not found. Please try the '{0}' option first.", My.Resources.cmdCreateXML)
        End If
    End Function

    Private Function modifyElement() As String
        '显示如何修改元素的文本值
        Dim xDoc As New XmlDocument

        xDoc.Load(tempModifyXmlFile)

        Dim startxml As String = "Original XML:" & formattedNewLine & xDoc.OuterXml

        Dim xNode As XmlNode
        Dim xElem As XmlElement

        Dim xElmntFamily As XmlElement = Nothing
        xNode = xDoc.SelectSingleNode("//Person")

        If Not (xNode Is Nothing) Then
            xElem = CType(xNode, XmlElement)

            '将“Ben Smith”更改为“John Smith”
            xElem.InnerText = "John Smith"

            xDoc.Save(tempModifyXmlFile)
            Me.XmlEdit.Text = "Modified XML:" & formattedNewLine & xDoc.OuterXml
            Return startxml
        Else
            Return String.Format("Family Node was not found. Please try the '{0}' option first.", My.Resources.cmdCreateXML)
        End If
    End Function

    Private Function modifyAttribute() As String
        '显示如何修改现有属性值
        Dim xDoc As New XmlDocument

        xDoc.Load(tempModifyXmlFile)

        Dim startXml As String = "Original XML:" & formattedNewLine & xDoc.OuterXml

        Dim xNode As XmlNode
        Dim xElem As XmlElement

        For Each xNode In xDoc.SelectNodes("//Person")
            xElem = CType(xNode, XmlElement)

            Select Case xElem.GetAttribute("type")
                Case "father"
                    xElem.SetAttribute("type", "parent")
                    xElem.SetAttribute("gender", "male")
                Case "mother"
                    xElem.SetAttribute("type", "parent")
                    xElem.SetAttribute("gender", "female")
                Case "son"
                    xElem.SetAttribute("type", "child")
                    xElem.SetAttribute("gender", "male")
                Case "daughter"
                    xElem.SetAttribute("type", "child")
                    xElem.SetAttribute("gender", "female")
            End Select
        Next
        xDoc.Save(tempModifyXmlFile)

        Me.XmlEdit.Text = "Modified XML:" & formattedNewLine & xDoc.OuterXml
        Return startXml
    End Function

    Private Function validXML() As String
        Dim xDoc As New XmlDocument
        Dim result As String

        Try
            '如果 XML 文件（或相应的字符串）无效，将引发
            'XmlException 类型的异常。
            xDoc.Load(badXmlFile)

            '如果使用“bad”文件，应不会看到以下情况。
            result = "Valid XML File: " & badXmlFile
        Catch exp As XmlException
            result = "Invalid XML File: " & badXmlFile
        Catch exp As Exception
            '捕获任何其他异常。
            MsgBox(exp.Message, MsgBoxStyle.Critical, exp.Source)
            result = "Exception occured."
        End Try
        Return result
    End Function

    Private Function parseErrors() As String
        Dim xDoc As New XmlDocument
        Dim writer As New StringWriter

        Try
            '如果 XML 文件（或相应的字符串）
            '无效，将引发
            'XmlException 类型的异常。
            xDoc.Load(badXmlFile)

            '如果使用“bad”文件，应不会看到以下情况。
            writer.Write("Valid XML File: " & badXmlFile)
        Catch exp As XmlException
            With writer
                .WriteLine(exp.Message)
                '可以逐个获取这些项。
                .WriteLine(exp.LineNumber)
                .WriteLine(exp.LinePosition)

                '其他项位于参数数组中
                '在中断模式下查看。
            End With
        Catch exp As Exception
            '只是为了以防万一
            MsgBox(exp.Message, MsgBoxStyle.Critical, exp.Source)
        End Try
        Return writer.ToString

    End Function

    Private Function InsertTextNode(ByVal xDoc As XmlDocument, ByVal xNode As XmlNode, ByVal strTag As String, ByVal strText As String) As XmlElement
        '插入一个文本节点，作为 xNode 的子节点。
        '将标记设置为 strTag，将
        '文本设置为 strText。返回指向
        '新节点的指针。

        Dim xNodeTemp As XmlNode

        xNodeTemp = xDoc.CreateElement(strTag)
        xNodeTemp.AppendChild(xDoc.CreateTextNode(strText))
        xNode.AppendChild(xNodeTemp)

        Return CType(xNodeTemp, XmlElement)
    End Function

    Private Sub TraverseTree(ByVal sw As StringWriter, ByVal xNode As XmlNode, ByVal intLevel As Integer)
        Dim xNodeLoop As XmlNode

        '打印出当前节点的
        '节点名称。
        Dim s As New String(System.Convert.ToChar(vbTab), intLevel)
        sw.WriteLine(s & xNode.Name)

        '如果当前节点有子节点，则调用此
        '相同的过程，传入该节点。增大
        'lngLevel 值，以便缩进输出。
        If xNode.HasChildNodes Then
            For Each xNodeLoop In xNode.ChildNodes
                Call TraverseTree(sw, xNodeLoop, intLevel + 1)
            Next xNodeLoop
        End If
    End Sub

    Private Sub TraverseTreeType(ByVal sw As StringWriter, ByVal xNode As XmlNode, ByVal intLevel As Integer)
        Dim xNodeLoop As XmlNode

        '打印出当前节点的
        '节点名称。
        Dim s As New String(System.Convert.ToChar(vbTab), intLevel)
        Dim strValues() As String = {s, xNode.Name, xNode.NodeType.ToString()}
        sw.WriteLine("{0}{1} ({2})", strValues)

        '如果当前节点有子节点，则调用此
        '相同的过程，传入该节点。增大
        'lngLevel 值，以便缩进输出。
        If xNode.HasChildNodes Then
            For Each xNodeLoop In xNode.ChildNodes
                Call TraverseTreeType(sw, xNodeLoop, intLevel + 1)
            Next xNodeLoop
        End If
    End Sub

    Private Sub XmlTasks_ItemCheck(ByVal sender As Object, ByVal e As System.Windows.Forms.ItemCheckEventArgs) Handles XmlTasks.ItemCheck
        '已将某个命令旁边的复选框更改为选中，于是运行该命令。
        If e.NewValue = CheckState.Checked Then
            Me.XmlEdit.Text = String.Empty
            Me.XmlDisplay.Text = String.Empty

            '执行与选中项关联的任务。
            Dim theTask As Task = CType(Me.XmlTasks.Items(e.Index), Task)
            Dim result As String = theTask.Method.Invoke()

            '使用上次运行的命令更新状态栏
            Me.StatusStrip1.Text = "Last run command: " & theTask.Name
            Me.XmlDisplay.Text = result
        End If
    End Sub

    Private Sub exitToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles exitToolStripMenuItem.Click
        Me.Close()
    End Sub

    Private Sub resetDisplayMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles resetDisplayMenuItem.Click
        '将选中的复选框重置为不选中。
        If Me.xmlTasks.CheckedItems.Count > 0 Then
            Me.xmlEdit.Text = String.Empty
            Me.xmlDisplay.Text = String.Empty
            For item As Integer = 0 To Me.xmlTasks.Items.Count - 1
                Me.xmlTasks.SetItemCheckState(item, CheckState.Unchecked)
            Next
        End If
    End Sub
End Class


